/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.text.folding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.ElementChangedEvent;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnElementDelta;
import org.asnlab.asndt.core.IComponentType;
import org.asnlab.asndt.core.IElementChangedListener;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.IParent;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.dom.Comment;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.internal.core.CompilationUnit;
import org.asnlab.asndt.internal.core.SourceRange;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.text.DocumentCharacterIterator;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingStructureProvider;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingStructureProviderExtension;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAsnFoldingStructureProvider
implements IAsnFoldingStructureProvider,
IAsnFoldingStructureProviderExtension {
    private ITextEditor fEditor;
    private ProjectionListener fProjectionListener;
    private IAsnElement fInput;
    private IElementChangedListener fElementListener;
    private boolean foldingAnonymousMembersEnabled = false;
    private boolean fCollapseComments = false;
    private boolean fCollapseExportContainer = true;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseMembers = false;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer) {
        Assert.isLegal((editor != null ? 1 : 0) != 0);
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        this.internalUninstall();
        if (editor instanceof AsnEditor) {
            this.fEditor = editor;
            this.fProjectionListener = new ProjectionListener(viewer);
        }
    }

    @Override
    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.fEditor instanceof AsnEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            AsnCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fElementListener != null) {
            AsnCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    @Override
    public final void initialize() {
        this.update(this.createInitialContext());
    }

    private FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences();
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    private FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private IAsnElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputAsnElement((IEditorPart)this.fEditor, false);
    }

    private void initializePreferences() {
        IPreferenceStore store = AsnPlugin.getDefault().getPreferenceStore();
        this.foldingAnonymousMembersEnabled = store.getBoolean("editor_folding_anonymous_members_enabled");
        this.fCollapseComments = store.getBoolean("editor_folding_default_comments");
        this.fCollapseExportContainer = store.getBoolean("editor_folding_default_exports");
        this.fCollapseImportContainer = store.getBoolean("editor_folding_default_imports");
        this.fCollapseMembers = store.getBoolean("editor_folding_default_members");
    }

    private void update(FoldingStructureComputationContext ctx) {
        if (ctx == null) {
            return;
        }
        HashMap<AsnProjectionAnnotation, Position> additions = new HashMap<AsnProjectionAnnotation, Position>();
        ArrayList<AsnProjectionAnnotation> deletions = new ArrayList<AsnProjectionAnnotation>();
        ArrayList<AsnProjectionAnnotation> updates = new ArrayList<AsnProjectionAnnotation>();
        this.computeFoldingStructure(ctx);
        LinkedHashMap updated = ctx.fMap;
        Map previous = this.computeCurrentStructure(ctx);
        for (AsnProjectionAnnotation newAnnotation : updated.keySet()) {
            IAsnElement element = newAnnotation.getElement();
            Position newPosition = (Position)updated.get((Object)newAnnotation);
            List annotations = (List)previous.get(element);
            if (annotations == null) {
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                Tuple tuple = (Tuple)x.next();
                AsnProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (newAnnotation.isComment() != existingAnnotation.isComment()) continue;
                if (existingPosition != null && (!newPosition.equals((Object)existingPosition) || ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed())) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed()) {
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            previous.remove(element);
        }
        for (List list : previous.values()) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(((Tuple)list.get((int)i)).annotation);
                ++i;
            }
        }
        this.match(deletions, additions, updates, ctx);
        Annotation[] removals = new Annotation[deletions.size()];
        deletions.toArray(removals);
        Annotation[] changes = new Annotation[updates.size()];
        updates.toArray(changes);
        ctx.getModel().modifyAnnotations(removals, additions, changes);
    }

    private void computeFoldingStructure(FoldingStructureComputationContext ctx) {
        CompilationUnit compilationUnit = (CompilationUnit)this.fInput;
        try {
            CompilationUnitDeclaration ast = (CompilationUnitDeclaration)compilationUnit.getAst();
            if (ast != null) {
                this.computeCommentsFoldingStructure(compilationUnit, ast.comments, ctx);
            }
            this.computeFoldingStructure(compilationUnit.getChildren(), ctx);
        }
        catch (AsnModelException x) {
            AsnPlugin.log(x);
            x.printStackTrace();
        }
    }

    private void computeCommentsFoldingStructure(CompilationUnit compilationUnit, List<Comment> comments, FoldingStructureComputationContext ctx) {
        if (comments == null) {
            return;
        }
        boolean collapse = ctx.collapseComments();
        for (Comment comment : comments) {
            Position position;
            SourceRange sourceRange;
            ISourceRange normalized;
            if (!comment.isBlockComment() || (normalized = this.alignRange((ISourceRange)(sourceRange = new SourceRange(comment.sourceStart, comment.sourceEnd - comment.sourceStart + 1)), ctx)) == null || (position = this.createCommentPosition(normalized)) == null) continue;
            ctx.addProjectionRange(new AsnProjectionAnnotation(collapse, null, true), position);
        }
    }

    private void computeFoldingStructure(IAsnElement[] elements, FoldingStructureComputationContext ctx) throws AsnModelException {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            IAsnElement element = elements[i];
            if (element instanceof IComponentType) {
                if (!this.foldingAnonymousMembersEnabled) {
                    return;
                }
                element = ((IComponentType)element).getType();
            }
            this.computeFoldingStructure(element, ctx);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            ++i;
        }
    }

    protected void computeFoldingStructure(IAsnElement element, FoldingStructureComputationContext ctx) {
        boolean collapse = false;
        switch (element.getElementType()) {
            case 21: {
                collapse = ctx.collapseComments();
                break;
            }
            case 17: {
                collapse = ctx.collapseExportContainer();
                break;
            }
            case 18: {
                collapse = ctx.collapseImportContainer();
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                collapse = ctx.collapseMembers();
                break;
            }
            default: {
                return;
            }
        }
        try {
            ISourceRange sourceRange = ((ISourceReference)element).getSourceRange();
            ISourceRange normalized = this.alignRange(sourceRange, ctx);
            if (normalized != null) {
                Position position;
                Position position2 = position = element instanceof IMember ? this.createMemberPosition(normalized, (IMember)element) : this.createCommentPosition(normalized);
                if (position != null) {
                    ctx.addProjectionRange(new AsnProjectionAnnotation(collapse, element, false), position);
                }
            }
        }
        catch (AsnModelException asnModelException) {
            return;
        }
    }

    protected final ISourceRange alignRange(ISourceRange region, FoldingStructureComputationContext ctx) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new SourceRange(offset, endOffset - offset);
    }

    protected final Position createCommentPosition(ISourceRange aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createMemberPosition(ISourceRange aligned, IMember member) {
        return new AsnElementPosition(aligned.getOffset(), aligned.getLength(), member);
    }

    private ProjectionAnnotationModel getModel() {
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
    }

    private IDocument getDocument() {
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fEditor.getEditorInput());
    }

    private Map computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<IAsnElement, ArrayList<Tuple>> map = new HashMap<IAsnElement, ArrayList<Tuple>>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof AsnProjectionAnnotation)) continue;
            AsnProjectionAnnotation asn = (AsnProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)asn);
            Assert.isNotNull((Object)position);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(asn.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(asn.getElement(), list);
            }
            list.add(new Tuple(asn, position));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tuple)o1).position.getOffset() - ((Tuple)o2).position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    private void match(List deletions, Map additions, List changes, FoldingStructureComputationContext ctx) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<AsnProjectionAnnotation> newDeletions = new ArrayList<AsnProjectionAnnotation>();
        ArrayList<AsnProjectionAnnotation> newChanges = new ArrayList<AsnProjectionAnnotation>();
        Iterator deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            AsnProjectionAnnotation deleted = (AsnProjectionAnnotation)((Object)deletionIterator.next());
            Position deletedPosition = ctx.getModel().getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null, ctx);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions, ctx);
                addToDeletions = false;
            }
            if (match == null) continue;
            IAsnElement element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof AsnElementPosition && element instanceof IMember) {
                AsnElementPosition jep = (AsnElementPosition)deletedPosition;
                jep.setMember((IMember)element);
            }
            deletionIterator.remove();
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection annotations, Map positionMap, FoldingStructureComputationContext ctx) {
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            AsnProjectionAnnotation annotation = (AsnProjectionAnnotation)((Object)it.next());
            if (tuple.annotation.isComment() != annotation.isComment()) continue;
            Position position2 = position = positionMap == null ? ctx.getModel().getPosition((Annotation)annotation) : (Position)positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    @Override
    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    @Override
    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    @Override
    public final void collapseElements(IAsnElement[] elements) {
        HashSet<IAsnElement> set = new HashSet<IAsnElement>(Arrays.asList(elements));
        this.modifyFiltered(new AsnElementSetFilter(set, false), false);
    }

    @Override
    public final void expandElements(IAsnElement[] elements) {
        HashSet<IAsnElement> set = new HashSet<IAsnElement>(Arrays.asList(elements));
        this.modifyFiltered(new AsnElementSetFilter(set, true), true);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<AsnProjectionAnnotation> modified = new ArrayList<AsnProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            AsnProjectionAnnotation asn;
            Object annotation = iter.next();
            if (!(annotation instanceof AsnProjectionAnnotation) || expand != (asn = (AsnProjectionAnnotation)((Object)annotation)).isCollapsed() || !filter.match(asn)) continue;
            if (expand) {
                asn.markExpanded();
            } else {
                asn.markCollapsed();
            }
            modified.add(asn);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    private static final class AsnElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public AsnElementPosition(int offset, int length, IMember member) {
            super(offset, length);
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public void setMember(IMember member) {
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (AsnModelException asnModelException) {}
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (AsnModelException asnModelException) {}
            return nameStart - this.offset;
        }
    }

    private static final class AsnElementSetFilter
    implements Filter {
        private final Set fSet;
        private final boolean fMatchCollapsed;

        private AsnElementSetFilter(Set set, boolean matchCollapsed) {
            this.fSet = set;
            this.fMatchCollapsed = matchCollapsed;
        }

        public boolean match(AsnProjectionAnnotation annotation) {
            IAsnElement element;
            boolean stateMatch;
            boolean bl = stateMatch = this.fMatchCollapsed == annotation.isCollapsed();
            return stateMatch && !annotation.isComment() && !annotation.isMarkedDeleted() && this.fSet.contains(element = annotation.getElement());
        }
    }

    protected static final class AsnProjectionAnnotation
    extends ProjectionAnnotation {
        private IAsnElement fAsnElement;
        private boolean fIsComment;

        public AsnProjectionAnnotation(boolean isCollapsed, IAsnElement element, boolean isComment) {
            super(isCollapsed);
            this.fAsnElement = element;
            this.fIsComment = isComment;
        }

        IAsnElement getElement() {
            return this.fAsnElement;
        }

        void setElement(IAsnElement element) {
            this.fAsnElement = element;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "AsnProjectionAnnotation:\n\telement: \t" + this.fAsnElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment() + "\n";
        }
    }

    private static final class CommentFilter
    implements Filter {
        private CommentFilter() {
        }

        public boolean match(AsnProjectionAnnotation annotation) {
            return annotation.isComment() && !annotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IAsnElementDelta delta = this.findElement(DefaultAsnFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                DefaultAsnFoldingStructureProvider.this.update(DefaultAsnFoldingStructureProvider.this.createContext(false));
            }
        }

        private IAsnElementDelta findElement(IAsnElement target, IAsnElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IAsnElement element = delta.getElement();
            if (element.getElementType() > 5) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IAsnElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IAsnElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(AsnProjectionAnnotation var1);
    }

    protected final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        private LinkedHashMap fMap = new LinkedHashMap();

        FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            Assert.isNotNull((Object)document);
            Assert.isNotNull((Object)model);
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        IDocument getDocument() {
            return this.fDocument;
        }

        ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        public void addProjectionRange(AsnProjectionAnnotation annotation, Position position) {
            this.fMap.put(annotation, position);
        }

        public boolean collapseComments() {
            return this.fAllowCollapsing && DefaultAsnFoldingStructureProvider.this.fCollapseComments;
        }

        public boolean collapseExportContainer() {
            return this.fAllowCollapsing && DefaultAsnFoldingStructureProvider.this.fCollapseExportContainer;
        }

        public boolean collapseImportContainer() {
            return this.fAllowCollapsing && DefaultAsnFoldingStructureProvider.this.fCollapseImportContainer;
        }

        public boolean collapseMembers() {
            return this.fAllowCollapsing && DefaultAsnFoldingStructureProvider.this.fCollapseMembers;
        }
    }

    private static final class MemberFilter
    implements Filter {
        private MemberFilter() {
        }

        public boolean match(AsnProjectionAnnotation annotation) {
            IAsnElement element;
            return !annotation.isComment() && !annotation.isMarkedDeleted() && (element = annotation.getElement()) instanceof IMember;
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            DefaultAsnFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DefaultAsnFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private static final class Tuple {
        AsnProjectionAnnotation annotation;
        Position position;

        Tuple(AsnProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

