/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.folding;

import org.asnlab.asndt.internal.ui.text.folding.EmptyAsnFoldingPreferenceBlock;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingPreferenceBlock;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingStructureProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class AsnFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    AsnFoldingStructureProviderDescriptor(IConfigurationElement element) {
        this.fElement = element;
        this.fId = element.getAttribute(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = element.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = element.getAttribute(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = element.getAttribute(PREFERENCES_CLASS) != null;
    }

    public IAsnFoldingStructureProvider createProvider() throws CoreException {
        IAsnFoldingStructureProvider prov = (IAsnFoldingStructureProvider)this.fElement.createExecutableExtension(CLASS);
        return prov;
    }

    public IAsnFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IAsnFoldingPreferenceBlock prefs = (IAsnFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return prefs;
        }
        return new EmptyAsnFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

