/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn.hover;

import org.asnlab.asndt.internal.ui.text.asn.hover.AbstractAsnEditorTextHover;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnEditorTextHoverDescriptor;
import org.asnlab.asndt.ui.text.asn.hover.IAsnEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class AsnEditorTextHoverProxy
extends AbstractAsnEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private AsnEditorTextHoverDescriptor fHoverDescriptor;
    private IAsnEditorTextHover fHover;

    public AsnEditorTextHoverProxy(AsnEditorTextHoverDescriptor descriptor, IEditorPart editor) {
        this.fHoverDescriptor = descriptor;
        this.setEditor(editor);
    }

    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    private boolean ensureHoverCreated() {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return false;
        }
        return this.isCreated() || this.createHover();
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
        return this.isCreated();
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

