/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.LineIterator;

public class EndianUtils {
    public static void writeSwappedShort(OutputStream a2, short a3) throws IOException {
        OutputStream outputStream = a2;
        outputStream.write((byte)(a3 >> 0 & 0xFF));
        outputStream.write((byte)(a3 >> 8 & 0xFF));
    }

    public static short readSwappedShort(byte[] a2, int a3) {
        return (short)(((a2[a3 + 0] & 0xFF) << 0) + ((a2[a3 + 1] & 0xFF) << 8));
    }

    private static /* synthetic */ int read(InputStream a2) throws IOException {
        int n2 = a2.read();
        if (-1 == n2) {
            throw new EOFException(LineIterator.K("i9Y/L2_#Y3\u001c\u0012s\u0011\u001c%Y6_?Y3"));
        }
        return n2;
    }

    public static void writeSwappedLong(OutputStream a2, long a3) throws IOException {
        OutputStream outputStream = a2;
        long l2 = a3;
        OutputStream outputStream2 = a2;
        long l3 = a3;
        OutputStream outputStream3 = a2;
        outputStream3.write((byte)(a3 >> 0 & 0xFFL));
        outputStream3.write((byte)(a3 >> 8 & 0xFFL));
        a2.write((byte)(l3 >> 16 & 0xFFL));
        outputStream2.write((byte)(l3 >> 24 & 0xFFL));
        outputStream2.write((byte)(a3 >> 32 & 0xFFL));
        a2.write((byte)(l2 >> 40 & 0xFFL));
        outputStream.write((byte)(l2 >> 48 & 0xFFL));
        outputStream.write((byte)(a3 >> 56 & 0xFFL));
    }

    public static int readSwappedInteger(InputStream a2) throws IOException {
        InputStream inputStream = a2;
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        int n5 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16) + ((n5 & 0xFF) << 24);
    }

    public static void writeSwappedFloat(byte[] a2, int a3, float a4) {
        EndianUtils.writeSwappedInteger(a2, a3, Float.floatToIntBits(a4));
    }

    public static String K(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = 4 << 4 ^ 5;
        int cfr_ignored_0 = (3 ^ 5) << 4 ^ 4 << 1;
        int n5 = n3;
        int n6 = (2 ^ 5) << 4;
        while (n5 >= 0) {
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n6);
            if (n3 < 0) break;
            int n8 = n3--;
            cArray[n8] = (char)(a2.charAt(n8) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    public static int readSwappedInteger(byte[] a2, int a3) {
        return ((a2[a3 + 0] & 0xFF) << 0) + ((a2[a3 + 1] & 0xFF) << 8) + ((a2[a3 + 2] & 0xFF) << 16) + ((a2[a3 + 3] & 0xFF) << 24);
    }

    public static double swapDouble(double a2) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(a2)));
    }

    public static void writeSwappedShort(byte[] a2, int a3, short a4) {
        a2[a3 + 0] = (byte)(a4 >> 0 & 0xFF);
        a2[a3 + 1] = (byte)(a4 >> 8 & 0xFF);
    }

    public static void writeSwappedInteger(OutputStream a2, int a3) throws IOException {
        OutputStream outputStream = a2;
        int n2 = a3;
        a2.write((byte)(a3 >> 0 & 0xFF));
        a2.write((byte)(n2 >> 8 & 0xFF));
        outputStream.write((byte)(n2 >> 16 & 0xFF));
        outputStream.write((byte)(a3 >> 24 & 0xFF));
    }

    public static double readSwappedDouble(byte[] a2, int a3) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(a2, a3));
    }

    public static int readSwappedUnsignedShort(InputStream a2) throws IOException {
        InputStream inputStream = a2;
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8);
    }

    public static short readSwappedShort(InputStream a2) throws IOException {
        return (short)(((EndianUtils.read(a2) & 0xFF) << 0) + ((EndianUtils.read(a2) & 0xFF) << 8));
    }

    public static void writeSwappedInteger(byte[] a2, int a3, int a4) {
        int n2 = a3;
        a2[a3 + 0] = (byte)(a4 >> 0 & 0xFF);
        a2[n2 + 1] = (byte)(a4 >> 8 & 0xFF);
        a2[n2 + 2] = (byte)(a4 >> 16 & 0xFF);
        a2[a3 + 3] = (byte)(a4 >> 24 & 0xFF);
    }

    public static void writeSwappedFloat(OutputStream a2, float a3) throws IOException {
        EndianUtils.writeSwappedInteger(a2, Float.floatToIntBits(a3));
    }

    public static float readSwappedFloat(InputStream a2) throws IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(a2));
    }

    public static long swapLong(long a2) {
        return ((a2 >> 0 & 0xFFL) << 56) + ((a2 >> 8 & 0xFFL) << 48) + ((a2 >> 16 & 0xFFL) << 40) + ((a2 >> 24 & 0xFFL) << 32) + ((a2 >> 32 & 0xFFL) << 24) + ((a2 >> 40 & 0xFFL) << 16) + ((a2 >> 48 & 0xFFL) << 8) + ((a2 >> 56 & 0xFFL) << 0);
    }

    public static void writeSwappedDouble(byte[] a2, int a3, double a4) {
        EndianUtils.writeSwappedLong(a2, a3, Double.doubleToLongBits(a4));
    }

    public static int readSwappedUnsignedShort(byte[] a2, int a3) {
        return ((a2[a3 + 0] & 0xFF) << 0) + ((a2[a3 + 1] & 0xFF) << 8);
    }

    public static double readSwappedDouble(InputStream a2) throws IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(a2));
    }

    public static int swapInteger(int a2) {
        return ((a2 >> 0 & 0xFF) << 24) + ((a2 >> 8 & 0xFF) << 16) + ((a2 >> 16 & 0xFF) << 8) + ((a2 >> 24 & 0xFF) << 0);
    }

    public static long readSwappedLong(byte[] a2, int a3) {
        long l2 = ((a2[a3 + 0] & 0xFF) << 0) + ((a2[a3 + 1] & 0xFF) << 8) + ((a2[a3 + 2] & 0xFF) << 16) + ((a2[a3 + 3] & 0xFF) << 24);
        return ((long)(((a2[a3 + 4] & 0xFF) << 0) + ((a2[a3 + 5] & 0xFF) << 8) + ((a2[a3 + 6] & 0xFF) << 16) + ((a2[a3 + 7] & 0xFF) << 24)) << 32) + (0xFFFFFFFFL & l2);
    }

    public EndianUtils() {
        EndianUtils a2;
    }

    public static float readSwappedFloat(byte[] a2, int a3) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(a2, a3));
    }

    public static void writeSwappedLong(byte[] a2, int a3, long a4) {
        int n2 = a3;
        int n3 = a3;
        a2[a3 + 0] = (byte)(a4 >> 0 & 0xFFL);
        a2[a3 + 1] = (byte)(a4 >> 8 & 0xFFL);
        a2[n3 + 2] = (byte)(a4 >> 16 & 0xFFL);
        a2[n3 + 3] = (byte)(a4 >> 24 & 0xFFL);
        a2[a3 + 4] = (byte)(a4 >> 32 & 0xFFL);
        a2[n2 + 5] = (byte)(a4 >> 40 & 0xFFL);
        a2[n2 + 6] = (byte)(a4 >> 48 & 0xFFL);
        a2[a3 + 7] = (byte)(a4 >> 56 & 0xFFL);
    }

    public static short swapShort(short a2) {
        return (short)(((a2 >> 0 & 0xFF) << 8) + ((a2 >> 8 & 0xFF) << 0));
    }

    public static long readSwappedUnsignedInteger(InputStream a2) throws IOException {
        InputStream inputStream = a2;
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        int n5 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16) + ((n5 & 0xFF) << 24);
    }

    public static float swapFloat(float a2) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(a2)));
    }

    public static long readSwappedUnsignedInteger(byte[] a2, int a3) {
        return ((a2[a3 + 0] & 0xFF) << 0) + ((a2[a3 + 1] & 0xFF) << 8) + ((a2[a3 + 2] & 0xFF) << 16) + ((a2[a3 + 3] & 0xFF) << 24);
    }

    public static void writeSwappedDouble(OutputStream a2, double a3) throws IOException {
        EndianUtils.writeSwappedLong(a2, Double.doubleToLongBits(a3));
    }

    public static long readSwappedLong(InputStream a2) throws IOException {
        int n2;
        byte[] byArray = new byte[8];
        int n3 = n2 = 0;
        while (n3 < 8) {
            byArray[n2++] = (byte)EndianUtils.read(a2);
            n3 = n2;
        }
        return EndianUtils.readSwappedLong(byArray, 0);
    }
}

